DROP TABLE IF EXISTS `folders`;

CREATE TABLE `folders` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ModifiedOn` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `Acronym` varchar(20) default NULL,
  `Family` varchar(50) default NULL,
  `FolderName` varchar(255) default NULL,
  `FolderCode` varchar(255) default NULL,
  `DateImaged` date default NULL,
  `TimeImaged` time default NULL,
  `ImagedBy` varchar(50) default NULL,
  `Notes` varchar(255) default NULL,
  PRIMARY KEY  (`ID`),
  KEY `Acronym` (`Acronym`),
  KEY `FolderName` (`FolderName`),
  KEY `FolderCode` (`FolderCode`),
  KEY `DateImaged` (`DateImaged`),
  KEY `TimeImaged` (`TimeImaged`),
  KEY `ImagedBy` (`ImagedBy`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `images`;

CREATE TABLE `images` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ModifiedOn` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `AllowOnline` char(1) default 'Y',
  `SpecimenID` int(10) unsigned default NULL,
  `ImageName` varchar(50) default NULL,
  `ImagedBy` varchar(50) default NULL,
  `DateImaged` date default NULL,
  `TimeImaged` time default NULL,
  `Family` varchar(50) default NULL,
  `FolderName` varchar(255) default NULL,
  `FolderCode` varchar(255) default NULL,
  `Notes` varchar(255) default NULL,
  PRIMARY KEY  (`ID`),
  KEY `SpecimenID` (`SpecimenID`),
  KEY `ImageName` (`ImageName`),
  KEY `AllowOnline` (`AllowOnline`),
  KEY `Family` (`Family`),
  KEY `FolderName` (`FolderName`),
  KEY `FolderCode` (`FolderCode`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;